/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import com.example.worldresetmod.DeletionDiagnosticUtil;
import com.example.worldresetmod.FileDeleteUtil;
import java.io.File;

public class FileDeleteUtilTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: FileDeleteUtilTest <file_path>");
            return;
        }
        String filePath = args[0];
        File testFile = new File(filePath);
        System.out.println("=== Java Enhanced Deletion Test ===");
        System.out.println("Test file: " + testFile.getAbsolutePath());
        System.out.println();
        if (!testFile.exists()) {
            System.out.println("[INFO] File doesn't exist - test not needed");
            return;
        }
        System.out.println("Running diagnostic analysis...");
        String diagnosticReport = DeletionDiagnosticUtil.analyzeDeletionFailure(testFile);
        System.out.println(diagnosticReport);
        System.out.println();
        System.out.println("Testing enhanced deletion...");
        boolean deleted = FileDeleteUtil.enhancedDeleteFile(testFile);
        System.out.println();
        System.out.println("=== Test Result ===");
        if (deleted) {
            System.out.println("[SUCCESS] File was successfully deleted!");
        } else {
            System.out.println("[FAILED] File could not be deleted");
            System.out.println("File still exists: " + testFile.exists());
        }
        System.out.println();
        System.out.println("Enhanced deletion test completed.");
    }
}

